import java.io.IOException;
import java.nio.file.*;

class FilesCopy {
	public static void main(String[] args) throws IOException {
		Path quelle = Path.of("quelle.dat");
		Path ziel = Path.of("ziel.dat");
		long zeit = System.currentTimeMillis();
		System.out.println("Kopieren von "+quelle+" in "+ziel+ " gestartet:");
		Files.copy(quelle, ziel, StandardCopyOption.REPLACE_EXISTING);
		zeit = System.currentTimeMillis() - zeit;
		System.out.println("\nEs wurden " + Files.size(quelle) + " Bytes kopiert. "+
				"(Benötigte Zeit: " + zeit + " Millisekunden.)");
	}
}